* Title: Appendix 3: Content Formatting
* Slug: formatting-guide

================================================================

Help documents are formatted using <a href="http://daringfireball.net/projects/markdown/syntax">Markdown syntax</a> enhanced with our custom tags. Markdown is well documented online (check the link in previous sentence), so I will not get into that, but I will explain tags that our system adds. 

There are two types of tags: open tags (functions) and tags that wrap content between them (blocks). Here are the examples:

<{code}><{literal}><{open_tag attribute_1="value 1" attribute_2="value 2"}>

<{block attribute_1="value 1" attribute_2="value 2"}>Some Content Here<{/block}><{/literal}><{/code}>

Key difference between the two is that blocks are usually content wrappers (for code, notes, special styling etc), while function are used to insert elements in the content.

Following functions are available:

<{sub}>image<{/sub}>

This function will insert image in the text. This function has one required attribute (<{code}>name<{/code}>) which specifies the name of the image that you want to insert in the next. Image of that name needs to exist in <{path}>/images<{/path}> of your book, videos or what's new section.

Example:

<{code inline=false}><{literal}><{image name='screenshot.png'}><{/literal}><{/code}>

<{sub}>related_video<{/sub}>

This function is used to render a block that links to one or more related video clips. Only one attribute is required (<{code}>name<{/code}>) and it is used to specify names of one or more video clips.

Example:

<{code inline=false}><{literal}><{related_video name='intro'}> or 

<{related_video name='bring-everyone-aboard,project-management-101'}><{/literal}><{/code}>

Following blocks are available:

<{sub}>article<{/sub}>

Use this block to link to a news article. <{code}>name<{/code}> attribute is required and it is used to specify to which article you want to link to (slug notation).

Example:

<{code inline=false}><{literal}>With version 4.1 we introduced numerous <{article name='calendar-improvements'}>calendar enhancements<{/article}> which greatly improve usability of the product.<{/literal}><{/code}>

<{sub}>book<{/sub}>

Use this block to link to a book. <{code}>name<{/code}> attribute is required and it is used to specify to which book you want to link to (slug notation).

Example:

<{code inline=false}><{literal}>Read <{book name='projects'}>Project book<{/book}> to learn more.<{/literal}><{/code}>

<{sub}>page<{/sub}>

Use this block to link to a book page. <{code}>name<{/code}> attribute is required and it is used to specify to which page you want to link to (slug notation). If <{code}>book<{/code}> attribute is omitted, system will look for the page in the current book. <{code}>book<{/code}> attribute is required if you wish to link to a page in a different book, or you are linking to a page from within What's New article or a video description.

Example:

<{code inline=false}><{literal}>Open <{page name='in-this-book'}>page in this book<{/page}> or <{page name='in-another-book' book='other-book'}>page in a different book<{/page}>.<{/literal}><{/code}>

<{sub}>video<{/sub}>

This block is used when you want to link to a video clip. <{code}>name<{/code}> attribute is required and it is used to specify to which video clip you want to link to (slug notation).

Example:

<{code inline=false}><{literal}>Check <{video name='intro'}>Intro video<{/book}> to learn more about our product.<{/literal}><{/code}>

<{sub}>note<{/sub}>

This block is used to mark note within the content. Notes are displayed differently than the rest of the content. Example:

<{code inline=false}><{literal}><{note}>Check release notes for details<{/note}>

or

<{note title="Browser Compatibility"}>Our product is compatible with IE10 and up, Firefox, Safari and Chrome<{/note}><{/literal}><{/code}>

<{code}>title<{/code}> attribute is optional, but recommended because it makes clearer to the reader what the note is about (great for people who are skimming content in search for an answer).

<{sub}>option<{/sub}>

This block is used to clearly outline that particular bit is name of an option or page in the interface. Example:

<{code inline=false}><{literal}>License key is available in <{option}>System Information<{/option}> block on <{option for="main_menu_admin"}>Administration<{/option}> page of your activeCollab.<{/literal}><{/code}>

If <{code}>for<{/code}> attribute is present and points to ID of a visible interface element, that element with flash in yellow color when user hovers the option text (check the Administration link in the example above). 

<{sub}>term<{/sub}>

This block is used to outline a particular application term or content. Example:

<{code inline=false}><{literal}>To create a new <{term}>To Do List<{/term}> please click on <{option for="page_action_new_todo_list"}>New To Do List<{/option}> button.<{/literal}><{/code}>

<{sub}>path<{/sub}>

This block is used to outline a file path or a file name in text. Paths are always displayed using monospace font:

<{code inline=false}><{literal}>Open <{path}>config/config.php<{/path}> and remove <{code}>APPLICATION_MODE<{/code}> directive from line 16.<{/literal}><{/code}>

<{sub}>code<{/sub}>

Code block is used for inserting code in the text. There are two main ways of inserting code:

1. Inline code examples are inserted directly in the text and are not expected to change the flow of the text,
2. Bigger, multi line code blocks with syntax highlighting. 

Example:

<{code inline=false}><{literal}><{code}>phpinfo()<{/code}> function will display info about your PHP. Here's a simple file that you can create to quickly see its output:

<{code highlight=php}><?php

    phpinfo(); // Call phpinfo() function

?><{/code}><{/literal}><{/code}>

When code block is displayed, optional <{code}>highlight<{/code}> attribute is available and you can use to tell the system how you would like the code to be highlighted. Follow syntaxes are supported:

* <{code}>cpp<{/code}> - C++
* <{code}>csharp<{/code}> - C#
* <{code}>css<{/code}> - CSS
* <{code}>php<{/code}> - For PHP code
* <{code}>python<{/code}> - Python
* <{code}>vb<{/code}> - Visual Basic
* <{code}>xml<{/code}> - HTML and XML

Example above will output the following result:

<{code}>phpinfo()<{/code}> function will display info about your PHP. Here's a simple file that you can create to quickly see its output:

<{code highlight=php}><?php

    phpinfo(); // Call phpinfo() function

?><{/code}>

<{sub}>sub<{/sub}>

This block is used to break a log page into sub-sections and produces <{code}>H3<{/code}> element. If <{code}>slug<{/code}> attribute is omitted it will be generated from section's name.

Example:

<{code inline=false}><{literal}><{sub}>Page Section<{/sub}>

Slug of this section will be "page-section".<{/literal}><{/code}>

<{sub}>step<{/sub}>

This block is used to break a process into several steps and have them properly displayed to the user. Example:

<{code inline=false}><{literal}>Follow these steps if you wish to have a nicely formatted document:

<{step num=1}>Define the steps<{/step}>
<{step num=2}>Document steps one by one. In steps you can use regular **Markdown formatting**, as well as all of our tags.

Also, you can break steps into multi line text, or even insert images when needed:

<{image name='test-image.png'}><{/step}>
<{step num=3}>There is no step 3!<{/step}><{/literal}><{/code}>

Result of this example will look something like this:

<{step num=1}>Define the steps<{/step}>
<{step num=2}>Document steps one by one. In steps you can use regular **Markdown formatting**, as well as all of our tags.

Also, you can break steps into multi line text, or even insert images when needed:

<{image name='test-image.png'}><{/step}>
<{step num=3}>There is no step 3!<{/step}>